<?php echo csrf_field(); ?>

<div class="row">
    <div class="col-md-6">
        <h5>Sender Information</h5>

        <label for="sender_name">Sender Name</label>
        <input id="sender_name" name="sender_name" class="form-control mb-2" placeholder="Sender Name"
            value="<?php echo e(old('sender_name', $courier->sender_name ?? '')); ?>" required>

        <label for="sender_email">Sender Email</label>
        <input id="sender_email" name="sender_email" type="email" class="form-control mb-2" placeholder="Sender Email"
            value="<?php echo e(old('sender_email', $courier->sender_email ?? '')); ?>" required>

        <label for="sender_address">Sender Address</label>
        <textarea id="sender_address" name="sender_address" class="form-control mb-2" placeholder="Sender Address" required><?php echo e(old('sender_address', $courier->sender_address ?? '')); ?></textarea>
    </div>

    <div class="col-md-6">
        <h5>Receiver Information</h5>

        <label for="receiver_name">Receiver Name</label>
        <input id="receiver_name" name="receiver_name" class="form-control mb-2" placeholder="Receiver Name"
            value="<?php echo e(old('receiver_name', $courier->receiver_name ?? '')); ?>" required>

        <label for="receiver_email">Receiver Email</label>
        <input id="receiver_email" name="receiver_email" type="email" class="form-control mb-2"
            placeholder="Receiver Email" value="<?php echo e(old('receiver_email', $courier->receiver_email ?? '')); ?>" required>

        <label for="receiver_contact">contact</label>
        <input   id="receiver_contact" name="receiver_contact" class="form-control mb-2" placeholder="Contact"
            value="<?php echo e(old('receiver_contact', $courier->receiver_contact ?? '')); ?>" required>

        <label for="receiver_address">Receiver Address</label>
        <textarea id="receiver_address" name="receiver_address" class="form-control mb-2" placeholder="Receiver Address" required><?php echo e(old('receiver_address', $courier->receiver_address ?? '')); ?></textarea>
    </div>
</div>

<hr>

<h5>Package Details</h5>


<textarea id="description" name="description" class="form-control mb-2" placeholder="Package Description"><?php echo e(old('description', $courier->description ?? '')); ?></textarea>

<label for="quantity">Quantity</label>
<input id="quantity" name="quantity" type="number" class="form-control mb-2" placeholder="Quantity"
    value="<?php echo e(old('quantity', $courier->quantity ?? 1)); ?>" required>

<label for="weight">Weight (kg)</label>
<input id="weight" name="weight"  type="number" class="form-control mb-2" placeholder="Weight (kg)"
    value="<?php echo e(old('weight', $courier->weight ?? '0.4')); ?>">

    <label for="weight">payment_mode</label>
<input id="payment_mode" name="payment_mode"  type="text" class="form-control mb-2" placeholder="payment mode"
    value="<?php echo e(old('payment_mode', $courier->payment_mode ?? 'Bitcoin')); ?>">


    <label for="shipping_mode">Shipping Mode</label>
<select id="shipping_mode" name="shipping_mode" class="form-control mb-2">
    <option value="<?php echo e($courier->shipping_mode ?? 'Air Freight'); ?>">
        <?php echo e($courier->shipping_mode ?? 'Air Freight'); ?>

    </option>
    <option value="Air Freight">Air Freight</option>
    <option value="Sea Freight">Sea Freight</option>
    <option value="Road Freight">Road Freight</option>
    <option value="Rail Freight">Rail Freight</option>
</select>


<h5>Location & Delivery</h5>

<label for="origin">Origin</label>
<input id="origin" name="origin" class="form-control mb-2" placeholder="Origin"
    value="<?php echo e(old('origin', $courier->origin ?? '')); ?>" required>

<label for="current_location">Current Location</label>
<input id="current_location" name="current_location" class="form-control mb-2" placeholder="Current Location"
    value="<?php echo e(old('current_location', $courier->current_location ?? '')); ?>">

<label for="destination">Destination</label>
<input id="destination" name="destination" class="form-control mb-2" placeholder="Destination"
    value="<?php echo e(old('destination', $courier->destination ?? '')); ?>" required>

<label for="freight_cost">Freight Cost</label>
<input id="freight_cost" name="freight_cost" class="form-control mb-2" placeholder="Freight Cost"
    value="<?php echo e(old('freight_cost', $courier->freight_cost ?? '')); ?>">

<label for="estimated_delivery">Estimated Delivery Date</label>
<input id="estimated_delivery" name="estimated_delivery" type="date" class="form-control mb-2"
    value="<?php echo e(old('estimated_delivery', $courier->estimated_delivery ?? '')); ?>">

<label for="dispatch_date">Dispatch Date</label>
<input id="dispatch_date" name="dispatch_date" type="date" class="form-control mb-2"
    value="<?php echo e(old('dispatch_date', $courier->dispatch_date ?? '')); ?>">

<h5>Status</h5>

<label for="status">Shipment Status</label>
<select id="status" name="status" class="form-control " required>
    <?php
        $statuses = [
            'Approved', 'Available', 'Cancelled', 'Customs', 'Delivered', 'Dispenser',
            'Distribution', 'Earring Collection', 'Effective', 'In Transit', 'In warehouse',
            'Invoiced', 'On Hold', 'On route', 'Packaged', 'Pending'
        ];
        $selectedStatus = old('status', $courier->status ?? '');
    ?>

    <?php $__currentLoopData = $statuses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <option value="<?php echo e($status); ?>" <?php echo e($selectedStatus === $status ? 'selected' : ''); ?>>
            <?php echo e($status); ?>

        </option>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</select>




<label for="shipment_progress">Shipment Progress (e.g. 60%)</label>
<input id="shipment_progress" name="shipment_progress" class="form-control mb-2"
    placeholder="Shipment Progress e.g. 60%" value="<?php echo e(old('shipment_progress', $courier->shipment_progress ?? '')); ?>">

<div class="form-check mb-2">
    <input id="delivery_completion" name="delivery_completion" type="checkbox" class="form-check-input"
        <?php echo e(old('delivery_completion', $courier->delivery_completion ?? false) ? 'checked' : ''); ?>>
    
</div>

<h5>Photo</h5>
<?php if(isset($courier) && $courier->photo): ?>
    <img src="<?php echo e(asset('storage/app/public/' . $courier->photo)); ?>" width="100" class="mb-2"><br>
<?php endif; ?>

<label for="photo">Upload New Photo</label>
<input id="photo" type="file" name="photo" class="form-control mb-3">

<button type="submit" class="btn btn-success">Save</button>
<?php /**PATH C:\xampp\htdocs\cargoflow\resources\views/admin/couriers/form.blade.php ENDPATH**/ ?>